# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliGlobal
import ConfigMount

gv = CliGlobal.CliGlobal( dict( ethPhyIntfDefaultConfigDir=None ) )

# --------------------------------------------------------------------------------
# [ no | default ] logging mac fault
# --------------------------------------------------------------------------------

def MacFaultLoggingCmdHandler( mode, args ):
   gv.ethPhyIntfDefaultConfigDir.macFaultLogging = True

def MacFaultLoggingCmdNoHandler( mode, args ):
   gv.ethPhyIntfDefaultConfigDir.macFaultLogging = False

# ------------------------------------------------------
# Plugin method
# ------------------------------------------------------

def Plugin( em ):
   gv.ethPhyIntfDefaultConfigDir = ConfigMount.mount(
      em,
      "interface/config/eth/phy/globalDefault",
      "Interface::EthPhyIntfGlobalDefaultConfigDir", "w" )
