# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliDynamicSymbol import CliDynamicPlugin
from CliPlugin.MacsecCli import (
   config
)

macsecDynamicSubProfilemode = CliDynamicPlugin( "MacsecProfileCli" )

def gotoMacsecProfileMode( mode, args ):
   profileName = args[ 'PROFILENAME' ]
   # Create a new profile object if it doesnt exist.
   config.profile.newMember( profileName )
   # Transition into the new mode.
   childMode = mode.childMode( macsecDynamicSubProfilemode.MacsecProfileMode,
                               profileName=profileName )
   mode.session_.gotoChildMode( childMode )
