# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac
import LazyMount
from CliPlugin.MgmtGnmiClientModeCli import (
   MgmtGnmiClientMode,
   GnmiServerMode,
   GnmiServerGroupMode
)
from TypeFuture import TacLazyType

config = None
GnmiConstants = TacLazyType( 'MgmtGnmiClient::GnmiConstants' )

# ------------------------------------------------------------
# switch(config)# [no|default] management client api gnmi
# ------------------------------------------------------------
def gotoMgmtGnmiClientMode( mode, args ):
   childMode = mode.childMode( MgmtGnmiClientMode )
   mode.session_.gotoChildMode( childMode )

def noMgmtGnmiClientMode( mode, args ):
   config.gnmiServerGroup.clear()
   config.gnmiServer.clear()

# ------------------------------------------------------------
# switch(config-mgmt-client-api-gnmi)# [no|default] server SERVER_NAME
# ------------------------------------------------------------
def addGnmiServer( mode, args ):
   gnmiServerName = args[ 'NAME' ]
   gnmiServer = Tac.Value( 'MgmtGnmiClient::GnmiServer', gnmiServerName,
                           '', # Default Hostname
                           GnmiConstants.gnmiServerVrfDefault,
                           GnmiConstants.gnmiServerPortDefault,
                           '', # Default Username
                           GnmiConstants.gnmiServerPasswordDefault )
   config.gnmiServer.addMember( gnmiServer )
   childMode = mode.childMode( GnmiServerMode, gnmiServerName=gnmiServerName,
                               config=config )
   mode.session_.gotoChildMode( childMode )

def removeGnmiServer( mode, args ):
   gnmiServerName = args[ 'NAME' ]
   del config.gnmiServer[ gnmiServerName ]

# ------------------------------------------------------------
# switch(config-gnmi-server-<SERVER_NAME>)# [no|default] address ADDRESS [port PORT]
# ------------------------------------------------------------
def modifyGnmiServerAddress( mode, args ):
   vrf = args[ 'VRF' ] if 'VRF' in args else GnmiConstants.gnmiServerVrfDefault
   port = args[ 'PORT' ] if 'PORT' in args else GnmiConstants.gnmiServerPortDefault
   hostname = args[ 'ADDRESS' ]
   mode.modifyAddressVrfPort( hostname, vrf, port )

def removeGnmiServerAddress( mode, args ):
   mode.modifyAddressVrfPort( '', # Default Hostname
                              GnmiConstants.gnmiServerVrfDefault,
                              GnmiConstants.gnmiServerPortDefault )

# ------------------------------------------------------------
# switch(config-gnmi-server-<SERVER_NAME>)# [no|default] username USERNAME password
#                                           PASSWORD
# ------------------------------------------------------------
def modifyGnmiServerUsernamePwd( mode, args ):
   username = args[ 'USERNAME' ]
   password = args[ 'PASSWORD' ]
   mode.modifyUsernamePassword( username, password )

def removeGnmiServerUsernamePwd( mode, args ):
   mode.modifyUsernamePassword( '', # Default Username
                                GnmiConstants.gnmiServerPasswordDefault )

# ------------------------------------------------------------
# switch(config-mgmt-client-api-gnmi)# [no|default] group GROUP_NAME
# ------------------------------------------------------------
def addGnmiServerGroup( mode, args ):
   gnmiServerGroupName = args[ 'GROUPNAME' ]
   config.gnmiServerGroup.newMember( gnmiServerGroupName )
   childMode = mode.childMode( GnmiServerGroupMode,
                               gnmiServerGroupName=gnmiServerGroupName,
                               config=config )
   mode.session_.gotoChildMode( childMode )

def removeGnmiServerGroup( mode, args ):
   gnmiServerGroupName = args[ 'GROUPNAME' ]
   del config.gnmiServerGroup[ gnmiServerGroupName ]

# ------------------------------------------------------------
# switch(config-gnmi-sg-<GROUP_NAME>)# [no|default] member SERVER_NAME>
# ------------------------------------------------------------
def addGnmiServerToServerGroup( mode, args ):
   gnmiServerName = args[ 'NAME' ]
   # server that does not exist in config.gnmiServer can also be added in
   # gnmiServerGroup. We can assume that user will configure them later.
   mode.addGnmiServer( gnmiServerName )

def removeGnmiServerFromServerGroup( mode, args ):
   gnmiServerName = args[ 'NAME' ]
   mode.removeGnmiServer( gnmiServerName )

def Plugin( entityManager ):
   global config
   config = LazyMount.mount( entityManager, 'mgmtGnmiClient/config',
                             'MgmtGnmiClient::Config', 'w' )
