#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Arnet import IpGenAddr
from CliDynamicSymbol import CliDynamicPlugin
from CliPlugin.RoutingBgpShowCli import BgpVrfRoutingContextDefaultOnly
from CliModel import cliPrinted

BgpVpnCliHandler = CliDynamicPlugin( "BgpVpnCliHandler" )
VpnCliHelperCommand = BgpVpnCliHandler.VpnCliHelperCommand
MvpnCliModels = CliDynamicPlugin( "MvpnCliModels" )
MvpnRoutesVrfModel = MvpnCliModels.MvpnRoutesVrfModel

class MvpnCliHelperCommand( VpnCliHelperCommand ):
   def __init__( self, mode, command, **kwargs ):
      super().__init__(
         mode, command, None, **kwargs )

   def run( self, **kwargs ):
      super().run( **kwargs )
      return cliPrinted( MvpnRoutesVrfModel )

@BgpVrfRoutingContextDefaultOnly( cliModel=MvpnRoutesVrfModel )
def doShowBgpMvpn( mode, **kwargs ):
   srcGrp = kwargs.pop( 'srcGrp', None )
   if srcGrp is not None:
      # Update kwargs with new key 'mvpnSrcGrp'
      first = srcGrp.get( 'IP1' )
      second = srcGrp.get( 'IP2' )
      if second is not None:
         # Both source and group are provided as filters
         first = IpGenAddr( first )
         second = IpGenAddr( second )
         if ( first.isUnicast and second.isUnicast ) or \
            ( first.isMulticast and second.isMulticast ):
            mode.addError( 'Must enter a multicast group and/or unicast source' )
            return None
         src = first if first.isUnicast else second
         grp = first if src != first else second
         # Add source first and group second with '|' as separator for backend
         # parsing
         srcGrpStr = f'{src.stringValue}|{grp.stringValue}'
      else:
         # One of source or group is provided as filters
         srcGrpStr = first
      kwargs[ 'mvpnSrcGrp' ] = srcGrpStr
   # Flatten the arguments
   setKwargs = {}
   VpnCliHelperCommand.flattenArgs( kwargs, setKwargs )

   return MvpnCliHelperCommand( mode, 'show bgp mvpn-ipvx', **setKwargs ).run()
