# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import CliDynamicSymbol
import CliGlobal
import ConfigMount

gv = CliGlobal.CliGlobal( ejectorCliConfigMount=None )

NorCalCardCliModel = CliDynamicSymbol.CliDynamicPlugin( 'NorCalCardCliModel' )

#-------------------------------------------------------------------------------
# command to configure fabriccard behavior for when ejector handles are open
#    requires 'config' mode
#
# full syntax:
#    hardware fabric ejector-handle open action [ power-off | log ]
#    [ no | default ] hardware fabric ejector-handle open action
#-------------------------------------------------------------------------------
def doHardwareEjectorHandlePowerOff( mode, args ):
   if gv.ejectorCliConfigMount is None:
      return
   gv.ejectorCliConfigMount.powerOff = True

def doHardwareEjectorHandle( mode, args ):
   if gv.ejectorCliConfigMount is None:
      return
   gv.ejectorCliConfigMount.powerOff = args[ 'VALUE' ] == 'power-off'

#-------------------------------------------------------------------------------
# show hardware fabric ejector-handle
#-------------------------------------------------------------------------------
def doShowHardwareEjectorHandle( mode, args ):
   ejectorHandleOpenAction = None
   if gv.ejectorCliConfigMount is not None:
      ejectorHandleOpenAction = ( 'power-off'
            if gv.ejectorCliConfigMount.powerOff else 'log' )
   return NorCalCardCliModel.HardwareFabricEjectorHandleModel(
         ejectorHandleOpenAction=ejectorHandleOpenAction )

def Plugin( entityManager ):
   if Cell.cellType() != 'supervisor':
      return

   gv.ejectorCliConfigMount = ConfigMount.mount(
      entityManager,
      'hardware/modularSystem/config/ejector',
      'Hardware::ModularSystem::EjectorCliConfig', 'w' )
