#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
import Tac

from CliPlugin import IntfCli
from CliPlugin.QosCliCommon import ( getIntfListFromMode, setIntfConfig,
                                     QosProfileMode, setQosProfileConfig )
from CliPlugin.QosCliScheduling import QosSchedulingPolicyMode
from QosLib import invalidGuaranteedBw
from QosTypes import ( tacGuaranteedBwUnit, tacGuaranteedBwVal, tacTxQueuePriority,
                       tacPercent, tacBwWeight )

invalidShapeRate = Tac.Value( 'Qos::ShapeRate' )

# -----------------------------------------------------------------------------------
# Variables for Qos Scheduling associated mount paths from Sysdb
# -----------------------------------------------------------------------------------
qosInputConfig = None

def setGuaranteedBw( mode, args ):
   guaranteedBw = args.get( 'PERCENT' ) or args.get( 'PPS' ) or \
                  args.get( 'KBPS' )
   guaranteedBwUnit = args.get( 'percent' ) or args.get( 'pps', 'kbps' )
   cfgGuaranteedBw = Tac.Value( 'Qos::GuaranteedBw' )
   cfgGuaranteedBw.bw = guaranteedBw
   if guaranteedBwUnit == 'pps':
      cfgGuaranteedBw.unit = tacGuaranteedBwUnit.guaranteedBwPps
   elif guaranteedBwUnit == 'percent':
      cfgGuaranteedBw.unit = tacGuaranteedBwUnit.guaranteedBwPercent
   else:
      cfgGuaranteedBw.unit = tacGuaranteedBwUnit.guaranteedBwKbps
   if isinstance( mode, QosProfileMode ):
      profile = mode.qosProfileModeContext.currentEntry_
      profile.guaranteedBw = cfgGuaranteedBw
   elif isinstance( mode.parent_, QosProfileMode ):
      profile = mode.parent_.qosProfileModeContext.currentEntry_
      txQueueConfig = profile.txQueueConfig.get( mode.txQueue )
      if not txQueueConfig:
         txQueueConfig = profile.txQueueConfig.newMember(
               mode.txQueue, tacTxQueuePriority.priorityInvalid,
               tacPercent.invalid, invalidShapeRate, cfgGuaranteedBw )
         return
      txQueueConfig.guaranteedBw = cfgGuaranteedBw
      setQosProfileConfig( profile )
   elif isinstance( mode, QosSchedulingPolicyMode ):
      policy = mode.qosSchedulingPolicyModeContext.currentEntry_
      policy.guaranteedBw = cfgGuaranteedBw
   elif isinstance( mode, IntfCli.IntfConfigMode ):
      intfList = getIntfListFromMode( mode )
      for intf in intfList:
         setIntfConfig( intf, cfgGuaranteedBw=cfgGuaranteedBw.bw,
                        cfgGuaranteedBwUnit=cfgGuaranteedBw.unit )
   else:
      intfList = getIntfListFromMode( mode.parent_ )
      for intf in intfList:
         intfConfig = qosInputConfig.intfConfig.get( intf )
         if intfConfig is None:
            intfConfig = qosInputConfig.intfConfig.newMember( intf )
            txQueueConfig = intfConfig.txQueueConfig.newMember(
               mode.txQueue, tacTxQueuePriority.priorityInvalid, tacPercent.invalid,
               invalidShapeRate, cfgGuaranteedBw )
         else:
            txQueueConfig = intfConfig.txQueueConfig.get( mode.txQueue )
            if txQueueConfig is None:
               txQueueConfig = intfConfig.txQueueConfig.newMember(
                  mode.txQueue, tacTxQueuePriority.priorityInvalid,
                  tacPercent.invalid, invalidShapeRate, cfgGuaranteedBw )
            else:
               txQueueConfig.guaranteedBw = cfgGuaranteedBw
         setIntfConfig( intf )

def noGuaranteedBw( mode, args ):
   guaranteedBw = tacGuaranteedBwVal.invalid
   cfgGuaranteedBw = Tac.Value( 'Qos::GuaranteedBw' )
   cfgGuaranteedBw.bw = guaranteedBw
   cfgGuaranteedBw.unit = tacGuaranteedBwUnit.guaranteedBwKbps
   if isinstance( mode.parent_, QosProfileMode ):
      profile = mode.parent_.qosProfileModeContext.currentEntry_
      txQueueConfig = profile.txQueueConfig.get( mode.txQueue )
      if not txQueueConfig:
         return
      txQueueConfig.guaranteedBw = cfgGuaranteedBw
      setQosProfileConfig( profile )
   elif isinstance( mode, QosProfileMode ):
      profile = mode.qosProfileModeContext.currentEntry_
      profile.guaranteedBw = cfgGuaranteedBw
      setQosProfileConfig( profile )
   elif isinstance( mode, QosSchedulingPolicyMode ):
      policy = mode.qosSchedulingPolicyModeContext.currentEntry_
      policy.guaranteedBw = cfgGuaranteedBw
   elif isinstance( mode, IntfCli.IntfConfigMode ):
      intfList = getIntfListFromMode( mode )
      for intf in intfList:
         intfConfig = qosInputConfig.intfConfig.get( intf )
         if not intfConfig:
            return
         intfConfig.guaranteedBw = cfgGuaranteedBw
         setIntfConfig( intf )
   else:
      intfList = getIntfListFromMode( mode.parent_ )
      for intf in intfList:
         intfConfig = qosInputConfig.intfConfig.get( intf )
         if intfConfig is not None:
            txQueueConfig = intfConfig.txQueueConfig.get( mode.txQueue )
            if txQueueConfig is not None:
               txQueueConfig.guaranteedBw = cfgGuaranteedBw
            setIntfConfig( intf )

def setBandwidth( mode, args ):
   bandwidthType = args.get( 'percent' ) or args.get( 'weight' )
   bandwidth = tacPercent.invalid
   bwWeight = tacBwWeight.invalid
   if bandwidthType == 'weight':
      bwWeight = args[ 'WEIGHT' ]
   if bandwidthType == 'percent':
      bandwidth = args[ 'PERCENT' ]
   if isinstance( mode.parent_, QosProfileMode ):
      profile = mode.parent_.qosProfileModeContext.currentEntry_
      txQueueConfig = profile.txQueueConfig.get( mode.txQueue )
      if not txQueueConfig:
         txQueueConfig = profile.txQueueConfig.newMember(
               mode.txQueue, tacTxQueuePriority.priorityInvalid, bandwidth,
               invalidShapeRate, invalidGuaranteedBw )
      else:
         txQueueConfig.bandwidth = bandwidth
      txQueueConfig.bandwidthWeight = bwWeight
      setQosProfileConfig( profile )
   else:
      intfList = getIntfListFromMode( mode.parent_ )
      for intf in intfList:
         intfConfig = qosInputConfig.intfConfig.get( intf )
         if intfConfig is None:
            intfConfig = qosInputConfig.intfConfig.newMember( intf )
            txQueueConfig = intfConfig.txQueueConfig.newMember(
               mode.txQueue, tacTxQueuePriority.priorityInvalid, bandwidth,
               invalidShapeRate, invalidGuaranteedBw )
            txQueueConfig.bandwidthWeight = bwWeight
         else:
            txQueueConfig = intfConfig.txQueueConfig.get( mode.txQueue )
            if txQueueConfig is None:
               txQueueConfig = intfConfig.txQueueConfig.newMember(
                  mode.txQueue, tacTxQueuePriority.priorityInvalid, bandwidth,
                  invalidShapeRate, invalidGuaranteedBw )
            else:
               txQueueConfig.bandwidth = bandwidth
            txQueueConfig.bandwidthWeight = bwWeight
         setIntfConfig( intf )

def noBandwidth( mode, args ):
   bandwidth = tacPercent.invalid
   bwWeight = tacBwWeight.invalid
   if isinstance( mode.parent_, QosProfileMode ):
      profile = mode.parent_.qosProfileModeContext.currentEntry_
      txQueueConfig = profile.txQueueConfig.get( mode.txQueue )
      if not txQueueConfig:
         return
      else:
         txQueueConfig.bandwidth = bandwidth
         txQueueConfig.bandwidthWeight = bwWeight
      setQosProfileConfig( profile )
   else:
      intfList = getIntfListFromMode( mode.parent_ )
      for intf in intfList:
         intfConfig = qosInputConfig.intfConfig.get( intf )
         if intfConfig is not None:
            txQueueConfig = intfConfig.txQueueConfig.get( mode.txQueue )
            if txQueueConfig is not None:
               txQueueConfig.bandwidth = bandwidth
               txQueueConfig.bandwidthWeight = bwWeight
            setIntfConfig( intf )

def Plugin( entityManager ):
   global qosInputConfig
   qosInputConfig = ConfigMount.mount( entityManager, "qos/input/config/cli",
                                       "Qos::Input::Config", "w" )
