#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import ConfigMount
import Tac
import CliGlobal
import CliDynamicSymbol

gv = CliGlobal.CliGlobal( config=None )
QosmibCounterIntervalModel = CliDynamicSymbol.CliDynamicPlugin(
      "QosSnmpCliModel" ).QosmibCounterIntervalModel

# Handler for SnmpMibQosmibCounterIntervalCmd
def doShowQosMibCounterInterval( mode, args ):
   ret = QosmibCounterIntervalModel()
   ret.enabled = gv.config.counterUpdateInterval != Tac.endOfTime
   if ret.enabled:
      ret.interval = int( gv.config.counterUpdateInterval )
   else:
      ret.interval = 0       # ignored
   return ret

# Handler for SnmpServerQosmibCounterIntervalUpdateintervalCmd:
def doUpdateQosMibCounterInterval( mode, args ):
   gv.config.counterUpdateInterval = args.get( 'UPDATE_INTERVAL',
                                                  Tac.endOfTime )

# --------------------------------------------------------------------------------
def Plugin( entityManager ):
   gv.config = ConfigMount.mount( entityManager, "snmp/qos/config",
                                        "QosSnmp::QosMibConfig", "w" )
