# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel

class QosmibCounterIntervalModel( CliModel.Model ):
   enabled = CliModel.Bool( help="QOS-MIB counters are enabled" )
   interval = CliModel.Int( help="QOS-MIB counter update interval (seconds)" )

   def render( self ):
      if self.enabled:
         print( "Updates to QOS counters will be triggered every:",
                 self.interval, "seconds." )
      else:
         print( "QOS counter updates are not enabled." )
