#!/usr/bin/env python3
# Copyright (c) 2019, 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount

ribSnmpConfig = None

def handlerSnmpServerRoutingMibsCmd( mode, args ):
   ribSnmpConfig.enabled = True

def noHandlerSnmpServerRoutingMibsCmd( mode, args ):
   ribSnmpConfig.enabled = False

def defaultHandlerSnmpServerRoutingMibsCmd( mode, args ):
   ribSnmpConfig.enabled = ribSnmpConfig.routingMibsDefault

def handlerSnmpServerRoutingMibsTimersPingRestartCmd( mode, args ):
   ribSnmpConfig.pingTime = args[ 'PING' ]
   ribSnmpConfig.restartTime = args[ 'RESTART' ]

def noOrDefaultHandlerSnmpServerRoutingMibsTimersPingRestartCmd( mode, args ):
   ribSnmpConfig.pingTime = ribSnmpConfig.pingTimeDefault
   ribSnmpConfig.restartTime = ribSnmpConfig.restartTimeDefault

def Plugin( entityManager ):
   global ribSnmpConfig

   ribSnmpConfig = ConfigMount.mount(
      entityManager, "routing/snmpConfig", "Routing::SnmpConfig", "w" )
