# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

ActionType = Tac.Type( "PolicyMap::ActionType" )

def SampleActionCmdHandler( mode, args ):
   if args.get( 'all' ):
      mode.context.setAction( ActionType.sampleAll, no=False,
                              clearActions=[ ActionType.sample ] )
   else:
      mode.context.setAction( ActionType.sample, no=False,
                              clearActions=[ ActionType.sampleAll ] )

def SampleActionCmdNoOrDefaultHandler( mode, args ):
   if args.get( 'all' ):
      mode.context.setAction( ActionType.sampleAll, no=True )
   else:
      mode.context.setAction( ActionType.sample, no=True )
