#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArnetModel import IpGenericAddress
from CliModel import (
   Bool,
   Int,
   List,
   Model,
   Str,
   Submodel,
)
from CliDynamicSymbol import CliDynamicPlugin
from IntfModels import Interface

AvtCliModel = CliDynamicPlugin( "AvtCliModel" )

class AvtFlowKey( Model ):
   __public__ = True
   vrf = Str( help="VRF name" )
   srcAddr = IpGenericAddress( help="Source IP address" )
   dstAddr = IpGenericAddress( help="Destination IP address" )
   ipProtocolNumber = Int( help="IP protocol number" )
   srcPort = Int( help="Source port" )
   dstPort = Int( help="Destination port" )

class AvtFlowInfo( Model ):
   key = Submodel( valueType=AvtFlowKey, help="Flow key" )
   avtName = Str( help="Name of adaptive virtual topology", optional=True )
   avtId = Int( help="Adaptive virtual topology identifier" )
   egressIntf = Interface( help="Flow egress interface", optional=True )
   nexthopVtepAddr = IpGenericAddress( help="Nexthop VTEP IP address",
                                       optional=True )
   transit = Bool( help="Transit node" )
   multihopPathId = Int( help="Multihop path ID", optional=True )
   directPathId = Int( help="Direct path ID", optional=True )
   lanPathId = Int( help="LAN path ID", optional=True )
   egressPathName = Str( help="Name of the egress path", optional=True )
   labelStack = List( valueType=AvtCliModel.AvtSegmentLabel,
                      help="Label stack of the multihop path", optional=True )

class AvtFlowsModel( Model ):
   __public__ = True
   ''' Model for show adaptive-virtual-topology flow'''
   flows = List( valueType=AvtFlowInfo, help="List of flows" )
