# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPrint import JSON
import Tac
import SharkUtils
from CliDynamicSymbol import CliDynamicPlugin

SharkModel = CliDynamicPlugin( "SharkModel" )

def showSharkClientsAll( mode, args, json ):
   cmd = SharkUtils.sharkWhoAll()
   if json:
      # TODO BUG978321: Support sharkWhoAllJson() in SharkCliHandler
      # Not supported yet
      mode.addError( 'JSON format for shark clients is not supported yet' )
      return None
   try:
      # run shark scanner to print all the clients. Note that we need to run this
      # command as root for meaningful information to be displayed.
      output = Tac.run( cmd, stdout=Tac.CAPTURE,
                        stderr=Tac.DISCARD,
                        asRoot=True )
      return output
   except Tac.SystemCommandError:
      mode.addError( 'Error printing shark clients' )
   return None

def sharkClientsAllHandler( mode, args ):
   fmt = mode.session_.outputFormat()

   # Currently, json format is not supported, so this option is
   # ignored
   jsonFormat = ( fmt == JSON )
   output = showSharkClientsAll( mode, args, json=jsonFormat )
   whoAllModel = SharkModel.WhoAll( _prettyOutput=output )

   return whoAllModel
