# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-next=consider-using-from-import
import CliPlugin.MaintenanceCliLib as MaintenanceCliLib
# pylint: disable-next=consider-using-from-import
import CliPlugin.MaintenanceModels as MaintenanceModels
from CliPlugin.MaintenanceModeShowCliCommon import gv

@MaintenanceCliLib.maintRunningShowCliCheck
def ShowMaintenanceSummaryCmd_handler( mode, _ ):
   model = MaintenanceModels.MaintenanceSummary()
   model.numUnitsConfigured = 0
   model.unitStatistics[ 'active' ] = 0
   model.unitStatistics[ 'underMaintenance' ] = 0
   model.unitStatistics[ 'maintenanceModeEnter' ] = 0
   model.unitStatistics[ 'maintenanceModeExit' ] = 0
   model.intfDirectlyInMaintenance[ 'underMaintenance' ] = 0
   model.intfDirectlyInMaintenance[ 'maintenanceModeEnter' ] = 0
   model.peerDirectlyInMaintenance[ 'underMaintenance' ] = 0
   model.peerDirectlyInMaintenance[ 'maintenanceModeEnter' ] = 0
   # Count the number of units configured by excluding the dynamic units
   for unitConfig in gv.unitConfigDir.config.values():
      if MaintenanceCliLib.isDynamicUnit( unitConfig ):
         continue
      model.numUnitsConfigured += 1
   # Count the units per state by excluding the dynamic units
   for unitStatus in gv.unitStatusDir.status.values():
      if MaintenanceCliLib.isDynamicUnit( unitStatus ):
         for group in unitStatus.group:
            if group.type == MaintenanceCliLib.intfGroupType:
               if unitStatus.state == 'maintenanceModeEnter':
                  model.intfDirectlyInMaintenance[ unitStatus.state ] += 1
               if unitStatus.state == 'underMaintenance':
                  model.intfDirectlyInMaintenance[ unitStatus.state ] += 1
            if group.type == MaintenanceCliLib.bgpGroupType:
               if unitStatus.state == 'maintenanceModeEnter':
                  model.peerDirectlyInMaintenance[ unitStatus.state ] += 1
               if unitStatus.state == 'underMaintenance':
                  model.peerDirectlyInMaintenance[ unitStatus.state ] += 1
         continue
      model.unitStatistics[ unitStatus.state ] = \
         model.unitStatistics.get( unitStatus.state, 0 ) + 1
   for hook in MaintenanceModels.showMaintenanceSummaryHook.extensions():
      hook( mode, model )
   return model
