# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Model, Submodel, Int, Str, List, Dict

class CapacityInfo( Model ):
   slots = Int( help='Current slots capacity', optional=True )
   buckets = Int( help='Current buckets capacity', optional=True )
   primaryNotifications = \
      Int( help='Current capacity of the primary conquer queue', optional=True )
   secondaryNotifications = \
      Int( help='Current capacity of the secondary conquer queue', optional=True )

class HeaderInfo( Model ):
   capacity = Submodel( valueType=CapacityInfo,
                        help='Current capacity information', optional=True )
   occupiedSlots = Int( help='Current number of occupied slots', optional=True )

class TableInfo( Model ):
   headerInfo = Submodel( HeaderInfo,
                          help='Header information of this Smash table' )
   writer = Str( help='The writer of this Smash table', optional=True )
   shadow = List( valueType=str, help='All shadows of this Smash table',
                   optional=True )
   keyshadow = List( valueType=str, help='All keyshadows of this Smash table',
                      optional=True )
   reader = List( valueType=str, help='All readers of this Smash table',
                   optional=True )

class WhoAll( Model ):
   # This dictionary field is only populated when json formatting is requested.
   # It is not used when rendering the text output.
   paths = Dict( keyType=str, valueType=TableInfo,
                      help='A mapping of the absolute path of the Smash table to '
                           'information about this table',
                 optional=True )
   # This string field stores the output of '/usr/bin/smash --who-all' and is 
   # returned to users when text formatting is requested. Otherwise, it is not 
   # populated.
   _prettyOutput = Str( help='Prettified output of each Smash table information',
                        optional=True )

   def render( self ):
      print( self._prettyOutput )
