# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount

from CliGlobal import CliGlobal
from CliDynamicPlugin.SwagModel import (
      MemberStatus,
      SwagSummary,
)
import Swag

gv = CliGlobal(
   dict(
      swagStatus=None,
) )

def ShowSwagSummary_handler( mode, args ):
   activeSupervisorMemberId = gv.swagStatus.candidateActiveSupervisorMemberId
   if Swag.isMember():
      activeSupervisorMemberId = Swag.activeMemberId()
   return SwagSummary(
         candidateId=gv.swagStatus.candidateMemberId,
         activeSupervisorId=activeSupervisorMemberId,
         vlan=gv.swagStatus.candidateVlan or Swag.vlan(),
         members={
            mid: MemberStatus(
               role=status.role, macAddress=status.macAddr,
               ipv4Address=status.ipAddr ) for mid, status in
            gv.swagStatus.member.items()
            }
   )

def Plugin( entityManager ):
   gv.swagStatus = LazyMount.mount( entityManager, 'swag/status',
                                    'Swag::SwagStatus', 'r' )
