#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import (
   DeferredModel,
   Dict,
   List,
   Int,
   Float )
from IntfModels import Interface

class TwampLightProbeModel( DeferredModel ):
   delay = Float( help="Delay in microseconds" )
   rxTime = Float( help="Rx time in seconds" )
   seqnum = Int( help="Sequence number" )

class TwampLightDelaysModel( DeferredModel ):
   interface = Interface( help="Name of the interface" )
   delays = List( valueType=TwampLightProbeModel,
                   help="TWAMP light delays in microseconds" )

class TwampLightResultsModel( DeferredModel ):
   results = Dict( keyType=str, valueType=TwampLightDelaysModel,
                   help="TWAMP light results" )
