#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import Tac
from CliMode.UrpfMode import ( UrpfLooseModeBase, UrpfStrictModeBase )
from CliPlugin.UrpfCli import routingHwConfig
import BasicCli

#---------------------------------------------------------------------------------
# Create new modes UrpfLooseMode/UrpfStrictMode to add Urpf configs under it
#---------------------------------------------------------------------------------
class UrpfLooseMode( UrpfLooseModeBase, BasicCli.ConfigModeBase ):
   name = "Loose mode uRPF Configuration"

   def __init__( self, parent, session ):
      UrpfLooseModeBase.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def urpfFailFwdSettingIs( self, value ):
      routingHwConfig.looseUrpfFailForceFwd = value

class UrpfStrictMode( UrpfStrictModeBase, BasicCli.ConfigModeBase ):
   name = "Strict mode uRPF Configuration"

   def __init__( self, parent, session ):
      UrpfStrictModeBase.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def urpfFailFwdSettingIs( self, value ):
      routingHwConfig.strictUrpfFailForceFwd = value

#-------------------------------------------------------------------------------#
# R1(config-router-urpf-loose)#[no|default] verify unicast source reachable-via any
# OR
# R1(config-router-urpf-strict)#[no|default] verify unicast source reachable-via rx
#
# No need to add guard because Urpf mode is already protected by guard
#-------------------------------------------------------------------------------#
class UrpfFailureDropOverrideCmd( CliCommand.CliCommandClass ):
   syntax = 'ipv4 ipv6 failure action forward'
   noOrDefaultSyntax = syntax

   data = {
      'ipv4': 'Enable for IPv4',
      'ipv6': 'Enable for IPv6',
      'failure': 'RPF check failure',
      'action': 'action to be taken during RPF failure',
      'forward': 'forward the packet in case of RPF check failure',
   }

   handler = ( 'UrpfCliHandler.urpfDropOverrideHandler' )
   noOrDefaultHandler = ( 'UrpfCliHandler.noOrDefaultUrpfDropOverrideHandler' )

UrpfLooseMode.addCommandClass( UrpfFailureDropOverrideCmd )
UrpfStrictMode.addCommandClass( UrpfFailureDropOverrideCmd )
