#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.UrpfCli import ( looseUrpfFailFwdSettingIs,
                                strictUrpfFailFwdSettingIs )
from CliDynamicPlugin.UrpfCli import ( UrpfLooseMode, UrpfStrictMode )
import Tac

def urpfModeHandler( mode, args ):
   newMode = UrpfLooseMode if 'any' in args else UrpfStrictMode 
   childMode = mode.childMode( newMode )
   mode.session_.gotoChildMode( childMode )

def noOrDefaultUrpfModeHandler( mode, args ):
   if 'any' in args:
      looseUrpfFailFwdSettingIs( False )
   else:
      strictUrpfFailFwdSettingIs( False )

def urpfDropOverrideHandler( mode, args ):
   mode.urpfFailFwdSettingIs( True )

def noOrDefaultUrpfDropOverrideHandler( mode, args ):
   mode.urpfFailFwdSettingIs( False )
