# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliGlobal
from CliPlugin import IntfCli
import ConfigMount
import Tac
import Toggles.GmpToggleLib

ctx = CliGlobal.CliGlobal( config=None )

def enableSnooping( mode, args ):
   '''(config-if-Vx1)# igmp snooping'''
   vtiConfig = ctx.config.newVtiConfig( mode.intf.name )
   vtiConfig.snoopingEnabled = True

def disableSnooping( mode, args ):
   '''(config-if-Vx1)# no igmp snooping'''
   vtiConfig = ctx.config.vtiConfig.get( mode.intf.name )
   if not vtiConfig:
      return
   vtiConfig.snoopingEnabled = False
   if vtiConfig.isDefault:
      del ctx.config.vtiConfig[ mode.intf.name ]

class VxlanIgmpSnoopingCleanup( IntfCli.IntfDependentBase ):

   def setDefault( self ):
      del ctx.config.vtiConfig[ self.intf_.name ]

def Plugin( em ):
   if not Toggles.GmpToggleLib.toggleVxlanIgmpSnoopingEnabled():
      return
   VxlanGmpSnoopingConfig = Tac.Type( "Bridging::Gmp::VxlanGmpSnoopingConfig" )
   ctx.config = ConfigMount.mount( em, VxlanGmpSnoopingConfig.mountPath( 'ipv4' ),
                                   "Bridging::Gmp::VxlanGmpSnoopingConfig", "w" )

   IntfCli.Intf.registerDependentClass( VxlanIgmpSnoopingCleanup )
