# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
import CliGlobal

from BasicCliModes import EnableMode
from CliPlugin import XcvrAllStatusDir
from CliPlugin.XcvrConfigCli import getXcvrConfigCliDirHelper
from CliPlugin.XcvrConfigCli import getXcvrConfigCliForConfigCommand
from EntityManager import Sysdb
from TypeFuture import TacLazyType
from XcvrLib import getSlotId, getXcvrStatus, isCmisTransceiver

gv = CliGlobal.CliGlobal( xcvrConfigCliSliceDir=None, xcvrStatusDir=None )
XcvrPresence = TacLazyType( "Xcvr::XcvrPresence" )

def xcvrReinitializeHandler( mode: EnableMode, args: dict[ str ] ) -> None:
   slotNames = args[ "SLOT" ]
   slotIdToXcvrStatusMapping = {}
   for xcvrName in gv.xcvrStatusDir.xcvrStatus:
      slotIdToXcvrStatusMapping[ getSlotId( xcvrName ) ] = getXcvrStatus(
         gv.xcvrStatusDir.xcvrStatus.get( xcvrName, None ) )

   slotsNotSupported = []
   for slotName in slotNames:
      slotId = getSlotId( slotName )
      xcvrStatus = slotIdToXcvrStatusMapping.get( slotId, None )
      if xcvrStatus is None or xcvrStatus.presence != XcvrPresence.xcvrPresent:
         continue

      if not isCmisTransceiver( xcvrStatus ):
         slotsNotSupported.append( slotId )
         continue

      primaryIntfName = xcvrStatus.xcvrConfig.intfName[ 0 ]
      xcvrConfigCliDir = getXcvrConfigCliDirHelper( primaryIntfName,
                                                    gv.xcvrConfigCliSliceDir )
      xcvrConfigCli = getXcvrConfigCliForConfigCommand( primaryIntfName,
                                                        xcvrConfigCliDir,
                                                        True )
      xcvrConfigCli.reinitRequest += 1

   if slotsNotSupported:
      mode.addWarning( "Transceiver reinitialization not supported for slots:\n\n   "
                       + "\n   ".join( slotsNotSupported ) + "\n" )

def Plugin( em: Sysdb ) -> None:
   gv.xcvrStatusDir = XcvrAllStatusDir.xcvrAllStatusDir( em )
   gv.xcvrConfigCliSliceDir = ConfigMount.mount( em,
                                                 "hardware/xcvr/cli/config/slice",
                                                 "Tac::Dir", "wi" )
