# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from CliDynamicSymbol import CliDynamicPlugin
from TypeFuture import TacLazyType

XcvrType = TacLazyType( 'Xcvr::XcvrType' )

decodeSfp = CliDynamicPlugin( 'XcvrEepromModel' ).decodeSfp
decodeQsfp = CliDynamicPlugin( 'XcvrEepromModel' ).decodeQsfp
decodeQsfpEnhancedDom = CliDynamicPlugin( 'XcvrEepromModel' ).decodeQsfpEnhancedDom
decodeCmis = CliDynamicPlugin( 'XcvrEepromModel' ).decodeCmis
XcvrShowEepromModel = CliDynamicPlugin( 'XcvrShowEepromModel' )
xcvrIdpromDumpFunc = CliDynamicPlugin( 'XcvrShowIdpromHandler' ).xcvrIdpromDumpFunc
getIdpromData = CliDynamicPlugin( 'XcvrShowIdpromHandler' ).getIdpromData

# ----------------------------------------------------------------------------
#
# "show interfaces [ <names> ] transceiver eeprom"
#
# ----------------------------------------------------------------------------

# Function to use to decode the EEPROM of a xcvr for a given xcvrType, should take a
# xcvrStatus and a model to fill for just that xcvr
eepromDecodeFuncs = {
                      XcvrType.osfp: ( decodeCmis, "eepromContents" ),
                      XcvrType.qsfpDd: ( decodeCmis, "eepromContents" ),
                      XcvrType.qsfpCmis: ( decodeCmis, "eepromContents" ),
                      XcvrType.dsfp: ( decodeCmis, "eepromContents" ),
                      XcvrType.sfpDd: ( decodeCmis, "eepromContents" ),
                      XcvrType.qsfpPlus: ( decodeQsfp, "sff8436IdEepromContents" ),
                      XcvrType.sfpPlus: ( decodeSfp, "sff8472IdEepromContents" ),
                    }

def _doDecodedEepromDump( mode, xcvrStatus, xcvrDir, intfs, model ):
   intfName = xcvrStatus.name
   if xcvrStatus.xcvrType not in eepromDecodeFuncs:
      # pylint: disable-next=consider-using-f-string
      print( "%s: decode not supported for this transceiver type" % intfName )
      return

   # Get the actual EEPROM data from xcvrStatus
   eeprom = getIdpromData( xcvrStatus )

   # Check if there was an error during the read. The value of 'eeprom' will be
   # None if the lastValidData timestamp predates the dump request timestamp.
   if xcvrStatus.presence == "xcvrPresent" and eeprom is None:
      # pylint: disable-next=consider-using-f-string
      print( "%s IDPROM: error retrieving data; read failed" % intfName )
   # The decode version will try to read as much as it can, regardless of xcvr
   # presence for sfp+, qsfp+, osfp and qsfpDd. Example: if we insert a faulty or
   # third-party xcvr, I believe status.presence gets stuck at xcvrPresenceUnknown
   else:
      anyData = eeprom and any( bool( pageData ) for _, pageData in eeprom )
      if anyData:
         model.interfaces[ intfName ] = \
            XcvrShowEepromModel.InterfacesTransceiverEepromIntf( _name=intfName )
         decode, eepromName = eepromDecodeFuncs[ xcvrStatus.xcvrType ]
         decode( getattr( xcvrStatus, eepromName ), model.interfaces[ intfName ] )
         if( xcvrStatus.typeInUse == XcvrType.qsfpPlus and
             xcvrStatus.isEnhancedDomSupported() ):
            decodeQsfpEnhancedDom( xcvrStatus, model.interfaces[ intfName ] )
      else:
         if len( intfs ) == 1:
            # pylint: disable-next=consider-using-f-string
            print( '%s: no data to print\n' % intfName )

def showInterfaceXcvrEeprom( mode, args ):
   intf = args.get( 'INTF' )
   mod = args.get( 'MOD' )
   model = XcvrShowEepromModel.InterfacesTransceiverEepromBase()
   xcvrIdpromDumpFunc( mode, _doDecodedEepromDump, model,
                       intf=intf, mod=mod )
   return model
