# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
import CliCommand
import CliGlobal
from CliDynamicPlugin.XcvrSimulateRemoveCliLib import (
   transceiverDiagSimulateRemovedCmdHelper )

gv = CliGlobal.CliGlobal( xcvrConfigCliSliceDir=None )

def TransceiverDiagSimulateRemovedCmdHandler( mode, args ):
   noOrDefault = CliCommand.isNoOrDefaultCmd( args )
   intfName = mode.intf.name
   transceiverDiagSimulateRemovedCmdHelper( intfName, not noOrDefault,
                                            gv.xcvrConfigCliSliceDir )

# -----------------------------------------------------------------------------------
# Plugin
# -----------------------------------------------------------------------------------

def Plugin( em ):
   gv.xcvrConfigCliSliceDir = ConfigMount.mount( em,
                                                 "hardware/xcvr/cli/config/slice",
                                                 "Tac::Dir", "wi" )
