# Copyright (c) 2006 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This module pretends to be CliInput, but is compatible with pdb.
# (CliInput refuses to load if pdb has loaded, because pdb uses readline).

try:
   from CliInput import * # pylint: disable=wildcard-import
except Exception as e: # pylint: disable=broad-except
   import sys
   sys.stderr.write( f"CliInputWrapper: CliInput: { e }\n" )

   def readline( prompt, completionCallback=None,
                 historyKey='', historyParentKey='' ):
      sys.stdout.write( prompt )
      return sys.stdin.readline()

   def history():
      return []

   def loggingSyncEnabledIs( filename, callback ):
      pass
