# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.RouterGeneral import RouterGeneralBaseMode

class RouteCountersVrfModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'route-counters-vrf-%s' % param
      self.longModeKey = 'route-counters-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RouteCountersModeBase )

class RouteCountersModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "route counters"

   def __init__( self, param ):
      self.modeKey = "route-counters"
      self.longModeKey = "route-counters"
      CliMode.ConfigMode.__init__( self, param, parentMode=RouterGeneralBaseMode )

class MonitorCounterMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "monitor counters"

   def __init__( self, param ):
      self.modeKey = "mon-counters"
      self.longModeKey = "mon-counters"
      CliMode.ConfigMode.__init__( self, param )

class MonitorCounterEthernetMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "ethernet interfaces"

   def __init__( self, param ):
      self.modeKey = "mon-counters-ethintfs"
      self.longModeKey = "mon-counters-ethintfs"
      CliMode.ConfigMode.__init__( self, param, parentMode=MonitorCounterMode )

class MonitorQueueCounterMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return "queue counters"

   def __init__( self, param ):
      self.modeKey = "mon-counters-queue"
      self.longModeKey = "mon-counters-queue"
      CliMode.ConfigMode.__init__( self, param, parentMode=MonitorCounterMode )

class TunnelCountersMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'tunnel-counters'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, None )

   def enterCmd( self ):
      return self.modeKey

class TunnelCountersTransmitMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'tunnel-counters-transmit'
      self.longModeKey = 'tunnel-counters-transmit'
      CliMode.ConfigMode.__init__( self, None, parentMode=TunnelCountersMode )

   def enterCmd( self ):
      return "transmit"
