#!/usr/bin/env python3
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class AliasMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'alias %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = "alias"
      self.longModeKey = "alias-%s" % param # pylint: disable=consider-using-f-string
      CliMode.ConfigMode.__init__( self, param )
