# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.BgpCommon import RoutingBgpBaseMode

# Bgp Session Tracker CLI mode
class BgpSessionTrackerMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'session tracker ' + self.trackerName

   def __init__( self, trackerName ):
      self.trackerName = trackerName
      self.modeKey = 'bgp-tracker-' + self.trackerName
      self.longModeKey = 'bgp-tracker-' + self.trackerName
      CliMode.ConfigMode.__init__( self, self.trackerName,
                                   parentMode=RoutingBgpBaseMode )
