# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode

class BgpGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'group bgp %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = 'group-bgp'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'group-bgp-%s' % param
      CliMode.ConfigMode.__init__( self, param )

class BgpBuiltinGroupMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'group bgp %s' % self.param_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      self.modeKey = 'builtin-group-bgp'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'builtin-group-bgp-%s' % param
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      # CliSave modes do not distinguish between built-in and non built-in modes
      return f'group-bgp-{self.param_}'
