# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliMode import ConfigMode
from CliMode.BgpCommon import RoutingBgpBaseMode

# config
#   router bgp <>
#     vpls <instance-name>
class BgpVplsInstanceMode( ConfigMode ):
   def __init__( self, vplsName ):
      self.vplsName = vplsName
      self.modeKey = f'router-bgp-vpls-{vplsName}'
      self.longModeKey = self.modeKey
      ConfigMode.__init__( self, vplsName, parentMode=RoutingBgpBaseMode )

   def enterCmd( self ):
      return f'vpls {self.vplsName}'

# config
#   router bgp <>
#     vpls <instance-name>
#        pseudowire <group-name>
class BgpVplsGroupMode( ConfigMode ):
   def __init__( self, vplsName, groupName ):
      self.vplsName = vplsName
      self.groupName = groupName
      self.modeKey = 'router-bgp-vpls-{vplsName}-group-{groupName}'.format(
         vplsName=vplsName, groupName=groupName )
      self.longModeKey = self.modeKey
      ConfigMode.__init__( self, groupName, parentMode=BgpVplsInstanceMode )

   def enterCmd( self ):
      return f'pseudowire {self.groupName}'

# config
#   router bgp <>
#     vpls <instance-name>
#        pseudowire <group-name>
#           signaling
class BgpVplsGroupSignalingMode( ConfigMode ):
   def __init__( self, vplsName, groupName ):
      self.vplsName = vplsName
      self.groupName = groupName
      self.modeKey = f'router-bgp-vpls-{vplsName}-group-{groupName}-signaling'
      self.longModeKey = self.modeKey
      ConfigMode.__init__( self, None, parentMode=BgpVplsGroupMode )

   def enterCmd( self ):
      return 'signaling'
