# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliMode
from CliMode.BgpCommon import RoutingBgpBaseMode

class RoutingBmpStationMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'monitoring station %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'router'
      self.bmpStationName = param
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'router-bgp-monitoring-station-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBgpBaseMode )
