# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Mgmt import ManagementMode

class CapiMgmtMode( ManagementMode ):
   # We define our own mode as we need different longModeKey and enterCmd

   def enterCmd( self ):
      return 'management api http-commands'

   def __init__( self ):
      ManagementMode.__init__( self, "api-http-cmds" )

class CapiVrfConfigModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'vrf %s' % self.vrfName_ # pylint: disable=consider-using-f-string

   def __init__( self, param ):
      ( self.vrfName_, self.config_ ) = param
      self.modeKey = "mgmt-api-http-cmds-vrf"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "mgmt-api-http-cmds-vrf-%s" % self.vrfName_
      CliMode.ConfigMode.__init__( self, param, parentMode=CliMode.ConfigMode )

   def config( self ):
      return self.config_.vrfConfig.newMember( self.vrfName_ )

