# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Te import GlobalTeMode
from CliMode.SrTePolicy import SrTeModeBase

class SrTeColorDscpModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "color-dscp-mappings"

   def __init__( self, param ):
      self.modeKey = "color-dscp"
      self.longModeKey = "te-sr-color-dscp"
      CliMode.ConfigMode.__init__( self, param, parentMode=SrTeModeBase )

class TeCbfModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'class-based-forwarding'

   def __init__( self, param ):
      self.modeKey = "cbf"
      self.longModeKey = "te-cbf"
      CliMode.ConfigMode.__init__( self, param, parentMode=GlobalTeMode )

class TeColorDscpModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'color-dscp-mappings'

   def __init__( self, param ):
      self.modeKey = "color-dscp"
      self.longModeKey = "te-cbf-color-dscp"
      CliMode.ConfigMode.__init__( self, param, parentMode=TeCbfModeBase )

class TeColorTcModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'color-tc-mappings'

   def __init__( self, param ):
      self.modeKey = "color-tc"
      self.longModeKey = "te-cbf-color-tc"
      CliMode.ConfigMode.__init__( self, param, parentMode=TeCbfModeBase )

class TeColorVrfModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'color-vrf-mappings'

   def __init__( self, param ):
      self.modeKey = "color-vrf"
      self.longModeKey = "te-cbf-color-vrf"
      CliMode.ConfigMode.__init__( self, param, parentMode=TeCbfModeBase )

class CbfFwdPlaneMplsSubModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'forwarding-plane mpls'

   def __init__( self, param ):
      self.modeKey = "mpls"
      self.longModeKey = "te-cbf-mpls"
      CliMode.ConfigMode.__init__( self, param, parentMode=TeCbfModeBase )
