#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.ContainerMgrMode import ContainerMgrMode

class ContainerProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'container-profile %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'container-mgr-container-profile'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'container-mgr-container-profile-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=ContainerMgrMode )
