#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class CvxDebugServiceMode( CliMode.ConfigMode ):
   def __init__( self, param ):
      self.modeKey = "cvx-debug"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "cvx-debug-%s" % param if param else "cvx-debug"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return 'cvx-debug'

   def enterCmd( self ):
      return "service debug"

class MgmtCvxDebugServiceMode( CliMode.ConfigMode ):
   def __init__( self, param ):
      self.modeKey = "mgmt-cvx-debug"
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "mgmt-cvx-debug-%s" % param if param else "mgmt-cvx-debug"
      CliMode.ConfigMode.__init__( self, param )

   def commentKey( self ):
      return 'mgmt-cvx-debug'

   def enterCmd( self ):
      return "service debug"
