#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliMode

class DecapGroupBaseMode( CliMode.ConfigMode ):
   def __init__( self, dgName ):
      self.modeKey = 'dg'
      self.longModeKey = 'dg-%s' % dgName # pylint: disable=consider-using-f-string
      self.dgName = dgName
      CliMode.ConfigMode.__init__( self, dgName )

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'ip decap-group %s' % self.dgName
