#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class DhcpRelayGlobalBaseMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "dhcp relay"

   def __init__( self ):
      self.modeKey = "dhcp"
      self.longModeKey = "dhcp-relay"
      CliMode.ConfigMode.__init__( self, None )

class InformationOptionBaseMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "information option"

   def __init__( self ):
      self.modeKey = "information"
      self.longModeKey = "information-option"
      CliMode.ConfigMode.__init__( self, None, 
            parentMode=DhcpRelayGlobalBaseMode )
