# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class Dot1xBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'dot1x'

   def __init__( self, param ):
      self.modeKey = "dot1x"
      self.longModeKey = "dot1x"
      CliMode.ConfigMode.__init__( self, param )

class Dot1xCacheResultsBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'result-caching'

   def __init__( self, param ):
      self.modeKey = "result-caching"
      self.longModeKey = "result-caching"
      CliMode.ConfigMode.__init__( self, param, parentMode=Dot1xBaseMode )

class Dot1xSuppProfileBaseMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'supplicant profile %s' % self.profileName

   def __init__( self, param ):
      self.modeKey = "supp-profile"
      self.profileName = param
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "dot1x-supp-profile-%s" % self.profileName

      CliMode.ConfigMode.__init__( self, param )
