# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class HardwareAclDuringUpdateMode( CliMode.ConfigMode ):
   UNSET = 0
   PERMIT = 1
   DENY = 2

   def enterCmd( self ):
      cmd = 'hardware access-list update default-result permit'
      if self.param_ == self.PERMIT:
         return cmd
      elif self.param_ == self.DENY:
         return f"no {cmd}"
      else:
         return f"default {cmd}"

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclIngressSharingMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'hardware access-list resource sharing vlan in'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclEgressIp6SharingMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'hardware access-list resource sharing vlan ipv6 out'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclEgressIpSharingOnMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'hardware access-list resource sharing vlan ipv4 out'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclEgressIpSharingOffMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'no hardware access-list resource sharing vlan ipv4 out'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclEgressIpLogRecirculationMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'hardware access-list logging egress ipv4 recirculate'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )

class HardwareAclEgressLogRecirculationMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'hardware access-list logging egress recirculate'

   def __init__( self, param ):
      self.modeKey = ""
      self.longModeKey = ""
      CliMode.ConfigMode.__init__( self, param )
