# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Mgmt import ManagementMode

class MgmtEosSdkRpcMode( ManagementMode ):
   # We define our own mode as we need different longModeKey and enterCmd

   def enterCmd( self ):
      return 'management api eos-sdk-rpc'

   def __init__( self ):
      ManagementMode.__init__( self, "api-eos-sdk-rpc" )

class EosSdkRpcTransportMode( CliMode.ConfigMode ):
   def __init__( self, param ):
      self.param = param
      self.modeKey = 'mgmt'
      self.longModeKey = f'eos-sdk-rpc-transport-{self.param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtEosSdkRpcMode )

   def enterCmd( self ):
      return f'transport grpc {self.param}'
