# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.BgpCommon import RoutingBgpVrfMode

class EthernetSegmentMode( CliMode.ConfigMode ):
   def __init__( self, domain=None ):
      self.domain = domain
      modeKey = 'evpn-es'
      if self.domain == "domain all":
         modeKey = 'evpn-es-domain-all'
      elif self.domain == "domain remote":
         modeKey = 'evpn-es-domain-remote'
      elif self.domain == "domain local":
         modeKey = 'evpn-es-domain-local'
      self.modeKey = modeKey
      self.longModeKey = modeKey
      CliMode.ConfigMode.__init__( self, None )

   def enterCmd( self ):
      return 'evpn ethernet-segment' + (
            ( ' ' + self.domain ) if self.domain is not None else '' )

class EvpnMulticastMode( CliMode.ConfigMode ):
   name = 'evpn multicast configuration'

   def enterCmd( self ):
      cmd = 'evpn multicast'
      return cmd

   def __init__( self, param ):
      self.vrfName_ = param
      self.modeKey = 'evpn-mcast-vrf'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'evpn-mcast-vrf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=RoutingBgpVrfMode )

class EvpnMulticastAfMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'address-family %s' % self.param_

   def __init__( self, param, vrfName ):
      self.addrFamily = param
      self.vrfName_ = vrfName
      # pylint: disable-next=consider-using-f-string
      self.modeKey = 'evpn-mcast-vrf-af'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'evpn-mcast-vrf-%s-af' % vrfName
      CliMode.ConfigMode.__init__( self, param, parentMode=EvpnMulticastMode )

   def commentKey( self ):
      return f"evpn-mcast-vrf-{self.vrfName_}-af-{self.addrFamily}"
