# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Intf import IntfMode
from TypeFuture import TacLazyType

IntfId = TacLazyType( "Arnet::IntfId" )

class EncapsulationBaseMode( CliMode.ConfigMode ):
   def __init__( self, intfName ):
      self.modeKey = "encap-vlan"
      intfShortName = IntfId( intfName ).shortName
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = "if-%s-%s" % ( intfShortName, self.modeKey )
      CliMode.ConfigMode.__init__( self, None, parentMode=IntfMode )

   def skipIfEmpty( self ):
      """ Allows us to unconditionally create the mode in CliSavePlugin
      (via getOrCreateModeInstance), rather than making it conditional on the
      presence of Config. As an added benefit, this will also display the
      mode if the only configuration that exists are comments.
      """
      return True

   def enterCmd( self ):
      return "encapsulation vlan"
