# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.FlowTracker import TrackerModeBase
from FlowTrackerCliUtil import getFtrPromptFromFtrTypeStr

class CongestionModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'record export on congestion'

   def __init__( self, param ):
      ( self.ftrTypeStr, self.trName ) = param
      self.modeKey = 'ftr-tr-congestion'
      ftrPrompt = getFtrPromptFromFtrTypeStr( self.ftrTypeStr )
      self.longModeKey = 'ftr-{}-tr-{}-congestion'.format(
                                   ftrPrompt, self.trName )
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=TrackerModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey
