# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from FlowTrackerCliUtil import getFtrPromptFromFtrTypeStr

class EncapFilterModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'encapsulation filter'

   def __init__( self, param ):
      self.ftrTypeStr = param
      self.modeKey = "encap-filter"
      ftrPrompt = getFtrPromptFromFtrTypeStr( self.ftrTypeStr )
      self.longModeKey = "config-ftr-%s-encap-filter" % ftrPrompt
      CliMode.ConfigMode.__init__( self, param )

   def instanceRuleKey( self ):
      return self.longModeKey
