# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.FlowTracker import TrackerModeBase
import BasicCli
from FlowTrackerCliUtil import ftrTypeKwStr, getFtrPromptFromFtrTypeStr

class GroupsModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'groups'

   def __init__( self, param ):
      ( self.ftrTypeStr, self.trName ) = param
      self.modeKey = 'ftr-tr-grps'
      ftrPrompt = getFtrPromptFromFtrTypeStr( self.ftrTypeStr )
      self.longModeKey = f'ftr-{ftrPrompt}-tr-{self.trName}-grps'
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=TrackerModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey

class GroupsMode( GroupsModeBase, BasicCli.ConfigModeBase ):
   name = 'Flow groups configuration'

   def __init__( self, parent, session ):
      self.session_ = session
      self.context_ = parent.context_
      GroupsModeBase.__init__( self,
                               ( ftrTypeKwStr[ self.context_.ftrType() ],
                               self.context_.trackerName() ) )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def context( self ):
      return self.context_

class GroupModeBase( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'group %s' % self.fgName

   def __init__( self, param ):
      ( self.ftrTypeStr, self.trName, self.seqno, self.fgName ) = param
      self.modeKey = 'ftr-tr-grps-grp'
      ftrPrompt = getFtrPromptFromFtrTypeStr( self.ftrTypeStr )
      self.longModeKey = 'ftr-{}-tr-{}-grps-grp-{}'.format(
                                    ftrPrompt, self.trName, self.fgName )
      CliMode.ConfigMode.__init__( self, self.longModeKey,
                                   parentMode=GroupsModeBase )

   def instanceRuleKey( self ):
      return self.longModeKey

class GroupMode( GroupModeBase, BasicCli.ConfigModeBase ):
   name = 'Flow group configuration'

   def __init__( self, parent, session, context, param ):
      self.session_ = session
      self.context_ = context
      ( seqno, groupName ) = param
      GroupModeBase.__init__( self, ( ftrTypeKwStr[ context.ftrType() ],
                                      context.trackerName(),
                                      seqno,
                                      groupName ) )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def context( self ):
      return self.context_
