# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMode
import Tracing
from CliMode.TrafficPolicy import ( MatchRuleBaseConfigMode,
                                    ActionsConfigModeBase,
                                    TrafficPolicyConfigModeBase )

POLICYMAP_FEATURE = 'flow-spec-policy'

__defaultTraceHandle__ = Tracing.Handle( 'Flowspec' )
t0 = __defaultTraceHandle__.trace0

class FlowspecModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return "flow-spec"

   def __init__( self ):
      self.modeKey = "flowspec"
      self.longModeKey = "flow-spec"
      CliMode.ConfigMode.__init__( self, None, parentMode=CliMode.ConfigMode )

class FlowspecConfigMode( FlowspecModeBase, BasicCli.ConfigModeBase ):
   """ flow-spec feature configuration """
   name = "flow-spec"

   def __init__( self, parent, session ):
      FlowspecModeBase.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def abort( self ):
      pass

   def commit( self ):
      pass

class FlowspecPoliciesModeBase( CliMode.ConfigMode ):
   """ flow-spec policies base configuration mode class """

   def enterCmd( self ):
      return 'policies'

   def __init__( self ):
      self.modeKey = 'policies'
      self.longModeKey = 'flow-spec-policies'
      CliMode.ConfigMode.__init__( self, None, parentMode=FlowspecConfigMode )

class FlowspecPoliciesConfigMode( FlowspecPoliciesModeBase,
                                  BasicCli.ConfigModeBase ):
   """ Configuration mode for flow-spec policies """
   name = "flow-spec-policies"

   def __init__( self, parent, session ):
      FlowspecPoliciesModeBase.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def abort( self ):
      pass

   def commit( self ):
      pass

class FlowspecPolicyConfigMode( TrafficPolicyConfigModeBase ):
   """ Configuration mode for a flow-spec policy """
   name = "flow-spec policy configuration"

   @property
   def configPolicyKeyword( self ):
      return 'policy'

class FlowspecPolicyMatchIpv4RuleConfigMode( MatchRuleBaseConfigMode ):
   name = 'flow-spec policy IPv4 match rule configuration'

class FlowspecPolicyMatchIpv6RuleConfigMode( MatchRuleBaseConfigMode ):
   name = 'flow-spec policy IPv6 match rule configuration'

class FlowspecPolicyActionsConfigMode( ActionsConfigModeBase ):
   name = 'flow-spec policy action configuration'
