# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliMode
import Tracing
from GeneratorCliUtils import generatorTypePromptStr
traceHandle = Tracing.Handle( 'GeneratorMode' )
t0 = traceHandle.trace0

class GeneratorsModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'monitor %s generators' % self.genType

   def __init__( self, param ):
      t0( "GeneratorsModeBase: ", param )
      self.genType = param
      genTypePrompt = generatorTypePromptStr.get( self.genType )
      self.modeKey = "mon-%s-gen" % genTypePrompt
      self.longModeKey = "mon-%s-gen" % genTypePrompt
      CliMode.ConfigMode.__init__( self, param )

   # By default Cli caches CLI Guards based on "enterCmd". For different features
   # CLI guard may not be invoked even though they are different types.
   # Use instanceRuleKey to make cache specific to different types. 
   def instanceRuleKey( self ):
      return self.longModeKey

class ProfilesModeBase( CliMode.ConfigMode ):
   def enterCmd( self ):
      return 'profile %s' % self.profileName

   def __init__( self, param ):
      t0( "ProfilesModeBase: ", param )
      ( self.genType, self.profileName ) = param
      genTypePrompt = generatorTypePromptStr.get( self.genType )
      self.modeKey = "mon-gen-prof"
      self.longModeKey = "mon-%s-gen-prof-%s" % \
                         ( genTypePrompt, self.profileName )
      CliMode.ConfigMode.__init__( self, param, parentMode=GeneratorsModeBase )

   # By default Cli caches CLI Guards based on "enterCmd". If different features
   # have same profile name, CLI guard may not be invoked even though they are
   # different types. Use instanceRuleKey to make cache specific to different types.
   def instanceRuleKey( self ):
      return self.longModeKey
