#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtGnmiMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api gnmi'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'mgmt-api-gnmi'
      CliMode.ConfigMode.__init__( self, param )

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return 'mgmt-' + cls.__name__

class GnmiTransportMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'transport grpc {self.param_}'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = f'gnmi-transport-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtGnmiMode )

class GrpctunnelTransportMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return f'transport grpc-tunnel {self.param_}'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = f'grpc-tunnel-transport-{param}'
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtGnmiMode )
