#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode

class MgmtGribiMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'management api gribi'

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'mgmt-api-gribi'
      CliMode.ConfigMode.__init__( self, param )

   # makes sure all management configurations are together
   @classmethod
   def modeSortKey( cls ):
      return 'mgmt-' + cls.__name__

class GribiTransportMode( CliMode.ConfigMode ):

   def enterCmd( self ):
      return 'transport grpc %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'mgmt'
      self.longModeKey = 'gribi-transport-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MgmtGribiMode )
