# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.Upnp import UpnpMode

class IgdMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = "upnp-igd"
      self.longModeKey = "upnp-igd"
      CliMode.ConfigMode.__init__( self, None, parentMode=UpnpMode )

   def enterCmd( self ):
      return "igd"

   def skipIfEmpty( self ):
      return True

class IgdVrfMode( CliMode.ConfigMode ):
   def __init__( self, vrfName ):
      self.vrfName = vrfName
      self.modeKey = "upnp-igd-vrf-%s" % vrfName
      self.longModeKey = "upnp-igd-vrf-%s" % vrfName
      CliMode.ConfigMode.__init__( self, vrfName, parentMode=IgdMode )

   def enterCmd( self ):
      return "vrf %s" % self.vrfName

   def skipIfEmpty( self ):
      return True
