# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMode
from CliMode.MaintenanceMode import MaintenanceMode

class IntfMaintenanceProfileMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      # pylint: disable-next=consider-using-f-string
      return 'profile interface %s' % self.param_

   def __init__( self, param ):
      self.modeKey = 'profile-intf'
      # pylint: disable-next=consider-using-f-string
      self.longModeKey = 'profile-intf-%s' % param
      CliMode.ConfigMode.__init__( self, param, parentMode=MaintenanceMode )
