#!/usr/bin/env python3
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=consider-using-f-string

import CliMode
import BasicCli
from IpLibConsts import DEFAULT_VRF

class VrfDefaultsBaseMode( CliMode.ConfigMode ):
   def __init__( self ):
      self.modeKey = 'vrf-defaults'
      self.longModeKey = self.modeKey
      CliMode.ConfigMode.__init__( self, self.longModeKey )

   def enterCmd( self ):
      return 'vrf defaults'

class VrfDefaultsMode( VrfDefaultsBaseMode, BasicCli.ConfigModeBase ):
   def __init__( self, parent, session ):
      VrfDefaultsBaseMode.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class VrfDefinitionBaseMode( CliMode.ConfigMode ):
   def __init__( self, vrfName ):
      self.modeKey = 'vrf'
      self.longModeKey = 'vrf-%s' % vrfName
      self.vrfName_ = vrfName
      CliMode.ConfigMode.__init__( self, vrfName )

   def enterCmd( self ):
      return 'vrf instance %s' % self.vrfName_

class NexthopGroupConfigBase( CliMode.ConfigMode ):
   def __init__( self, nexthopGroupName, nexthopGroupType ):
      self.modeKey = 'nexthop-group'
      self.longModeKey = 'nexthop-group-%s' % nexthopGroupName
      self.nexthopGroupName_ = nexthopGroupName
      self.nexthopGroupType = nexthopGroupType
      CliMode.ConfigMode.__init__( self, nexthopGroupName )

   def enterCmd( self ):
      return 'nexthop-group %s type %s' % ( self.nexthopGroupName_,
                                            self.nexthopGroupType )

class RouterKernelMode( CliMode.ConfigMode ):
   def enterCmd( self ):
      if self.vrfName != DEFAULT_VRF:
         return 'router kernel vrf %s' % ( self.vrfName )
      return 'router kernel'

   def __init__( self, param ):
      self.vrfName = param
      self.modeKey = "router"
      if self.vrfName == DEFAULT_VRF:
         self.longModeKey = "router-kernel"
      else:
         self.longModeKey = "router-kernel-vrf-%s" % self.vrfName
      CliMode.ConfigMode.__init__( self, param )

class IpHardwareEcmpFecMode( CliMode.ConfigMode ):
   def __init__( self, param ):
      self.modeKey = "hier-nh-ecmp"
      self.longModeKey = "hier-nexthop-ecmp"
      CliMode.ConfigMode.__init__( self, param=param )

   def enterCmd( self ):
      return 'ip hardware fib hierarchical next-hop ecmp'
